<?php
require_once ( get_template_directory() . '/theme-options.php' );
add_theme_support( 'automatic-feed-links' );
load_theme_textdomain( 'chemdry', get_template_directory() . '/languages' );

function register_my_menus() {
register_nav_menus(
array(
'primary-nav' => __( 'Primary Menu', 'chemdry' ),
'copyright' => __( 'Copyright', 'chemdry' ),
'footer-menu1' => __( 'Footer Menu Left', 'chemdry' ),
'footer-menu2' => __( 'Footer Menu Center', 'chemdry' ),
'footer-menu3' => __( 'Footer Menu Right', 'chemdry' ),
)
);
}
add_action( 'init', 'register_my_menus' );

function new_excerpt_length($length) {
    return 100;
}
add_filter('excerpt_length', 'new_excerpt_length');

add_post_type_support( 'page', 'excerpt' );
	


if ( ! isset( $content_width ) ) $content_width = 480;

 // Enable post thumbnails

add_theme_support( 'post-thumbnails', array( 'post', 'page' ) ); 
set_post_thumbnail_size(180,$variable, true);

add_action( 'init', 'codex_custom_init' );	

function codex_custom_init() {
  $labels = array(
    'name' => 'Products',
    'singular_name' => 'Product',
    'add_new' => 'Add New',
    'add_new_item' => 'Add New Product',
    'edit_item' => 'Edit Product',
    'new_item' => 'New Product',
    'all_items' => 'All Products',
    'view_item' => 'View Product',
    'search_items' => 'Search Products',
    'not_found' =>  'No Products found',
    'not_found_in_trash' => 'No Products found in Trash', 
    'parent_item_colon' => '',
    'menu_name' => 'Products'
  );

  $args = array(
    'labels' => $labels,
    'public' => true,
    'publicly_queryable' => true,
    'show_ui' => true, 
    'show_in_menu' => true, 
    'query_var' => true,
	'map_meta_cap' => true,
    'rewrite' => array( 'slug' => 'product' ),
    'capability_type' => 'page',
    'has_archive' => true, 
    'menu_position' => 20,
    'supports' => array( 'title', 'editor','author', 'thumbnail', 'excerpt', 'comments' ,'custom-fields')
  ); 

  register_post_type( 'product', $args );
}
  
  // hook into the init action and call create_book_taxonomies() when it fires
add_action( 'init', 'create_product_taxonomies', 0 );

// create two taxonomies, genres and writers for the post type "book"
function create_product_taxonomies() {

	// Add new taxonomy, make it hierarchical (like categories)
	$labels = array(
		'name' => _x( 'Product Types', 'taxonomy general name' ),
		'singular_name' => _x( 'Product Type', 'taxonomy singular name' ),
		'search_items' =>  __( 'Search  ' ),
		'all_items' => __( 'All Types' ),
		'parent_item' => __( 'Parent Type' ),
		'parent_item_colon' => __( 'Parent Type:' ),
		'edit_item' => __( 'Edit Type' ), 
		'update_item' => __( 'Update Type' ),
		'add_new_item' => __( 'Add New Type' ),
		'new_item_name' => __( 'New Genre Type' ),
	); 	

	register_taxonomy( 'type', array( 'product' ), array(
		'hierarchical' => true,
		'labels' => $labels, /* NOTICE: Here is where the $labels variable is used */
		'show_ui' => true,
		'query_var' => true,
		'rewrite' => array( 'slug' => 'type' ),
	));
}

	
//Special Sidebar Registration

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Blog Right',
'id' => 'sidebar_main',
'description' => 'Right Side of News & Posts',
'class'  => '',
'before_widget' => '<aside id="%1$s" class="widget">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
));
}
if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Blog Left',
'id' => 'sidebar_left',
'description' => 'Left Side of News & Posts',
'class'  => '',
'before_widget' => '<aside id="%1$s" class="widget">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
));
}
if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Category Left',
'id' => 'cat_left',
'description' => 'Left Side of Category Pages',
'class'  => '',
'before_widget' => '<aside id="%1$s" class="widget">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
));
}

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Homepage Right',
'id' => 'homepage_right',
'description' => 'Right Side of Homepage',
'class'  => '',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Homepage Feature 1',
'id' => 'homepage_feature1',
'description' => 'Appears on homepage 1st row left',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Homepage Feature 2',
'id' => 'homepage_feature2',
'description' => 'Appears on homepage 1st row middle',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}
if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Homepage Feature 3',
'id' => 'homepage_feature3',
'description' => 'Appears on homepage 1st row right',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Homepage Feature 4',
'id' => 'homepage_feature4',
'description' => 'Appears on homepage 2nd row left',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}
if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Homepage Feature 5',
'id' => 'homepage_feature5',
'description' => 'Appears on homepage 2nd row middle',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}
if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Homepage Feature 6',
'id' => 'homepage_feature6',
'description' => 'Appears on homepage 2nd row right',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'About Right',
'id' => 'about_right',
'description' => 'Right Side of About',
'class'  => '',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}


if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Experts Right',
'id' => 'experts_right',
'description' => 'Right Side of Experts',
'class'  => '',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}
if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Services Left',
'id' => 'services_left',
'description' => 'Left Side of Services',
'class'  => '',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}
if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Services Right',
'id' => 'services_right',
'description' => 'Reft Side of Services',
'class'  => '',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}


if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Products',
'id' => 'product_left',
'description' => 'Left Side of Product Pages',
'class'  => '',
'before_widget' => '<ul>',
'after_widget' => '</ul>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
));
}

if ( function_exists('register_sidebar') ) {
register_sidebar(array(
'name' => 'Contact',
'id' => 'contact_right',
'description' => 'Contact Page',
'class'  => '',
'before_widget' => '',
'after_widget' => '',
'before_title' => '',
'after_title' => '',
));
}







function my_search_form( $form ) {

    $form = '<form role="search" method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <input type="text" placeholder="Search Here" value="' . get_search_query() . '" name="s" id="s" />
    <input type="submit" class="button id="searchsubmit" value="'. esc_attr__('Search') .'" />
    </form>';

    return $form;
}

add_filter( 'get_search_form', 'my_search_form' );


?>
